/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.block;

import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.block.CharmBlockItem;
import svenhjol.charm.base.handler.RegistryHandler;
import svenhjol.charm.mixin.accessor.FireBlockAccessor;

public interface ICharmBlock {
    public boolean enabled();

    default public void register(CharmModule module, String name) {
        ResourceLocation id = new ResourceLocation(module.mod, name);
        RegistryHandler.block(id, (Block)this);
        RegistryHandler.register(ForgeRegistries.ITEMS, () -> this.createBlockItem(id));
    }

    default public ItemGroup getItemGroup() {
        return ItemGroup.field_78030_b;
    }

    default public int getBurnTime() {
        return 0;
    }

    default public int getMaxStackSize() {
        return 64;
    }

    @Nullable
    default public BlockItem createBlockItem(ResourceLocation id) {
        Item.Properties settings = new Item.Properties();
        ItemGroup itemGroup = this.getItemGroup();
        if (itemGroup != null) {
            settings.func_200916_a(itemGroup);
        }
        settings.func_200917_a(this.getMaxStackSize());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Supplier<Callable<ItemStackTileEntityRenderer>> ister = this.getISTER();
            if (ister != null) {
                settings.setISTER(ister);
            }
        });
        return new CharmBlockItem(this, settings);
    }

    default public BiConsumer<ItemStack, Boolean> getInventoryTickConsumer() {
        return null;
    }

    default public void setFireInfo(int encouragement, int flammability) {
        ((FireBlockAccessor)Blocks.field_150480_ab).invokeSetFireInfo((Block)this, encouragement, flammability);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    default public Supplier<Callable<ItemStackTileEntityRenderer>> getISTER() {
        return null;
    }
}

